// Full credits to Kyance [http://forum.sa-mp.com/member.php?u=197133]
// Big thanks to Virtual1ty for assisting me in optimising the code [http://forum.sa-mp.com/member.php?u=53564]

#define FILTERSCRIPT

#include <a_samp>
#include <zcmd>
#include <foreach>
#include <sscanf2>
#include <crashdetect>

#define MAX_SUBS 15

#define PRESSED(%0) \
	(((newkeys & (%0)) == (%0)) && ((oldkeys & (%0)) != (%0)))


#define PUB:%0(%1)	forward %0(%1); \
					public %0(%1)



enum sInfo
{
	ID, UserID, Object,
	Float:sX, Float:sY, Float:sZ, Float:sAngle,
	Torpedos, TorpedoLoaded, TorpedoObject,
	LifeBoat, LifeBoatID,
	Health,
	IsActive, InUse
};
new gSubmarineInfo[MAX_SUBS][sInfo];

enum lbInfo
{
	lbID, vehicleID
};
new gLifeboatInfo[MAX_SUBS][lbInfo];

new
	gSubmarines,
	gPlayerState	 	[MAX_PLAYERS char],
	gPlayerSubID	 	[MAX_PLAYERS],
	
	gPlayerCamObj		[MAX_PLAYERS],
	
	bool:gPlayerInSub	[MAX_PLAYERS char],
	bool:gPlayerCanShoot[MAX_PLAYERS char],
	bool:gPlayerLoading [MAX_PLAYERS char],
	gPlayerSubWarnTick  [MAX_PLAYERS],
	gPlayerShot			[MAX_PLAYERS],
	gPlayerDmg          [MAX_PLAYERS][MAX_SUBS],
	
	Text:SubInfo[MAX_PLAYERS], Text:SubBox[MAX_PLAYERS],
	Timer[MAX_PLAYERS]
;


forward Float:GetXYInFrontOfPlayer(playerid, &Float:q, &Float:w, Float:distance);
forward Float:GetXYInFrontOfObject(objectid, playerid, &Float:x, &Float:y, Float:distance);
//
stock Float:GetXYInFrontOfPlayer(playerid, &Float:q, &Float:w, Float:distance)
{
	new Float:a;
	GetPlayerPos(playerid, q, w, a);
	if (GetPlayerState(playerid) == PLAYER_STATE_DRIVER) GetVehicleZAngle(GetPlayerVehicleID(playerid), a);
	else GetPlayerFacingAngle(playerid, a);
	q += (distance * floatsin(-a, degrees));
	w += (distance * floatcos(-a, degrees));
	return a;
}

stock Float:GetXYInFrontOfObject(objectid, playerid, &Float:x, &Float:y, Float:distance)
{
    new Float:a;
    GetObjectPos(objectid, x, y, a);
    GetPlayerFacingAngle(playerid, a);

    x += (distance * floatsin(-a, degrees));
    y += (distance * floatcos(-a, degrees));
}

stock GetDistance( Float:x1, Float:y1, Float:z1, Float:x2, Float:y2, Float:z2 )
{
    return floatround( floatsqroot( ( ( x1 - x2 ) * ( x1 - x2 ) ) + ( ( y1 - y2 ) * ( y1 - y2 ) ) + ( ( z1 - z2 ) * ( z1 - z2 ) ) ) );
}
//

public OnFilterScriptInit()
{
	gSubmarines = 0;
    for (new i; i < _:sInfo; ++i) gSubmarineInfo[i][sInfo:i] = 0;
	foreach(Player, x) ResetData(x), KillTimer(Timer[x]);
	print("\n-> Submarine script v1.8.1 loaded\n-->Created by: Kyance and Virtual1ty");
	
	foreach(Player, i) OnPlayerConnect(i);
	
	//Timer = SetTimer("UpdateStats", 1200, 1);
	return 1;
}

public OnFilterScriptExit()
{
	print("\n-> Submarine script v1.8.1 unloaded\n-->Created by: Kyance and Virtual1ty");
	
	foreach(Player, i)
	{
	    if (gPlayerInSub{i})
	    {
			RemovePlayerFromSubmarine(i, gPlayerSubID[i]);
		}
		if (IsValidObject(gPlayerCamObj[i])) DestroyObject(gPlayerCamObj[i]);
		UnfreezePlayer(i);
		TextDrawDestroy(SubInfo[i]); TextDrawDestroy(SubBox[i]); KillTimer(Timer[i]);
	}
	DestroySubmarines(); //KillTimer(Timer);
	return 1;
}

RemovePlayerFromSubmarine(playerid, submarineid)
{
	gPlayerInSub   {playerid} = false;
	gPlayerSubID   [playerid] = -1;
	gPlayerCanShoot{ playerid } = false; KillTimer(Timer[playerid]);
	
	if (IsValidObject(gPlayerCamObj[playerid])) DestroyObject(gPlayerCamObj[playerid]);
    SetCameraBehindPlayer(playerid);
	gSubmarineInfo[submarineid][InUse] = 0; gSubmarineInfo[submarineid][IsActive] = 1; gSubmarineInfo[submarineid][UserID] = -1;
	TextDrawHideForPlayer(playerid, SubInfo[playerid]); TextDrawHideForPlayer(playerid, SubBox[playerid]);
	
	SetPlayerPos(playerid, gSubmarineInfo[submarineid][sX], gSubmarineInfo[submarineid][sY], gSubmarineInfo[submarineid][sZ]+3);
}

PutPlayerInSubmarine(playerid, submarineid)
{
	gPlayerInSub   {playerid} = true;
	gPlayerSubID   [playerid] = gSubmarineInfo[submarineid][ID];
	gPlayerCanShoot{ playerid}  = false; Timer[playerid] = SetTimerEx("UpdateStats", 800, 1, "ii", playerid, submarineid);

	gSubmarineInfo[submarineid][UserID] = playerid;
	gSubmarineInfo[submarineid][IsActive] = 1; gSubmarineInfo[submarineid][InUse] = 1;
	
	gPlayerCamObj[playerid] = CreateObject(19300, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	AttachObjectToObject(gPlayerCamObj[playerid], gSubmarineInfo[submarineid][Object], 0.0, -5.0, 1.6, 0.0, 0.0, 0.0);
	
	GetObjectPos(gSubmarineInfo[submarineid][Object], gSubmarineInfo[submarineid][sX], gSubmarineInfo[submarineid][sY], gSubmarineInfo[submarineid][sZ]);
	SetPlayerPos(playerid, gSubmarineInfo[submarineid][sX], gSubmarineInfo[submarineid][sY], gSubmarineInfo[submarineid][sZ] - 4.0);
	AttachCameraToObject(playerid, gPlayerCamObj[playerid]);
	
	new string[148], string2[4], Float:rotation;
	GetObjectRot(gSubmarineInfo[submarineid][Object], rotation, rotation, rotation);
	new Dir = floatround(rotation,floatround_round);
	if(Dir > 360) Dir -= 360;
	else if(Dir < 0) Dir += 360;
	switch(Dir)
    {
        case 0..22: string2 = "S"; //N
        case 23..67: string2 = "NW";
        case 68..112: string2 = "W";
        case 113..157: string2 = "SW";
        case 158..202: string2 = "N"; //S
        case 203..247: string2 = "SE";
        case 248..292: string2 = "E";
        case 293..337: string2 = "NE";
        case 338..360: string2 = "S"; //N
    }
    
	format(string, sizeof(string), "~w~TORPEDOS: ~y~%d~n~~w~LIFEBOAT: ~y~%d~n~~w~ARMOUR: ~y~%d~n~~w~ALTITUDE: ~y~%0.2f~n~~w~SPEED: ~y~%d knots~n~~w~DIRECTION: ~y~%s", gSubmarineInfo[submarineid][Torpedos], gSubmarineInfo[submarineid][LifeBoat], gSubmarineInfo[submarineid][Health], gSubmarineInfo[submarineid][sZ], GetPlayerSpeed(playerid), string2);
	TextDrawSetString(SubInfo[playerid], string);
	TextDrawShowForPlayer(playerid, SubInfo[playerid]);
	TextDrawShowForPlayer(playerid, SubBox[playerid]);
}

public OnPlayerConnect(playerid)
{
    ResetData(playerid);
    
	SubBox[playerid] = TextDrawCreate(560.000000, 387.200000, "~n~~n~~n~~n~~n~~n~"); //460 396.2
   	TextDrawBackgroundColor(SubBox[playerid], 255);
    TextDrawFont(SubBox[playerid], 2);
   	TextDrawLetterSize(SubBox[playerid], 0.199999,1.100000);
    TextDrawColor(SubBox[playerid], -1);
    TextDrawSetOutline(SubBox[playerid], 1);
    TextDrawSetProportional(SubBox[playerid], 1);
    TextDrawSetShadow(SubBox[playerid], 1);
    TextDrawUseBox(SubBox[playerid], 1);
   	TextDrawBoxColor(SubBox[playerid], 119);

	SubInfo[playerid] = TextDrawCreate(560.000000, 387.200000, "~w~TORPEDOS:~n~~w~LIFEBOAT:~w~ARMOUR:~n~~w~ALTITUDE:~n~~w~SPEED:~n~~y~DIRECTION:"); //460 396.2
	TextDrawBackgroundColor(SubInfo[playerid], 255);
	TextDrawFont(SubInfo[playerid], 2);
	TextDrawLetterSize(SubInfo[playerid], 0.199999,1.100000);
	TextDrawColor(SubInfo[playerid], -1);
 	TextDrawSetOutline(SubInfo[playerid], 1);
 	TextDrawSetProportional(SubInfo[playerid], 1);
 	TextDrawSetShadow(SubInfo[playerid], 1);
    return 1;
}

public OnPlayerDisconnect(playerid, reason)
{
	gPlayerState{playerid} = PLAYER_STATE_WASTED;
	
	if(gPlayerSubID[playerid])
	{
		RemovePlayerFromSubmarine(playerid, gPlayerSubID[playerid]);
		ResetData(playerid);
		TextDrawDestroy(SubInfo[playerid]);
		TextDrawDestroy(SubBox[playerid]);
	}
	return 1;
}

public OnPlayerDeath(playerid, killerid, reason)
{
	gPlayerState{playerid} = PLAYER_STATE_WASTED;
	if(gPlayerSubID[playerid])
	{
		RemovePlayerFromSubmarine(playerid, gPlayerSubID[playerid]);
		ResetData(playerid);
	}
	return 1;
}

public OnPlayerStateChange(playerid, newstate, oldstate)
{
	gPlayerState{playerid} = newstate;
	return 1;
}

public OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{
	if (gPlayerInSub{playerid})
	{
	    new Float:X, Float:Y, Float:Z;
	    GetPlayerPos(playerid, X, Y, Z);
		
		if (PRESSED(KEY_YES))
		{
		    if (gSubmarineInfo[gPlayerSubID[playerid]][TorpedoLoaded] && gPlayerCanShoot{playerid})
		    {
		        if (gSubmarineInfo[gPlayerSubID[playerid]][Torpedos] > 0)
		        {
		            GetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ]);
					new string[148];
					gPlayerCanShoot{playerid} = false;
					
		            gSubmarineInfo[gPlayerSubID[playerid]][Torpedos]--;
					format(string, sizeof(string), "{FFFFFF}* {00C0FF}SUBMARINE: Torpedo away! Remaining torpedos: %d/4", gSubmarineInfo[gPlayerSubID[playerid]][Torpedos]);
					SendClientMessage(playerid, -1, string);
					gSubmarineInfo[gPlayerSubID[playerid]][TorpedoObject] = CreateObject(1636, gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY] - 2.0, gSubmarineInfo[gPlayerSubID[playerid]][sZ], gSubmarineInfo[gPlayerSubID[playerid]][sAngle]+180, gSubmarineInfo[gPlayerSubID[playerid]][sAngle]+180, 0);
					gSubmarineInfo[gPlayerSubID[playerid]][sX] -= (150.0 * floatsin(-gSubmarineInfo[gPlayerSubID[playerid]][sAngle], degrees));
					gSubmarineInfo[gPlayerSubID[playerid]][sY] -= (150.0 * floatcos(-gSubmarineInfo[gPlayerSubID[playerid]][sAngle], degrees));
                    	
                    new time = MoveObject(gSubmarineInfo[gPlayerSubID[playerid]][TorpedoObject], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ], 65.0);
					SetTimerEx("DetonateTorpedo", time, false, "iii", gPlayerSubID[playerid], playerid, gSubmarineInfo[gPlayerSubID[playerid]][TorpedoObject]);
					format(string, sizeof(string), "{FFFFFF}* {00C0FF}SUBMARINE: The torpedo will explode in approx. %d seconds!", time/1000);
					SendClientMessage(playerid, -1, string);
				}
				else SendClientMessage(playerid, -1, "{FFFFFF}* {FC4949}SUBMARINE: You've ran out of torpedos!");
			}
			else
			{
			    if(!gPlayerLoading{ playerid })
			    {
				    SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}SUBMARINE: Loading torpedo..");
				    SetTimerEx("TorpedoLoadedT", 2500+random(3000), false, "ii", playerid, gPlayerSubID[playerid]);
				    gPlayerLoading{ playerid } = true;
				}
				else SendClientMessage(playerid, -1, "{FFFFFF}* {FC4949}SUBMARINE: You're already loading a torpedo!");
			}
		}
		else if (PRESSED(KEY_NO))
		{
		    if (gSubmarineInfo[gPlayerSubID[playerid]][LifeBoat])
		    {
		        GetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ]);
		        SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}SUBMARINE: Deploying lifeboat..");
		        SetTimerEx("LifeboatLoaded", 3000+random(2000), false, "ii", playerid, gPlayerSubID[playerid]);
			}
			else
			{
				new Float:X2, Float:Y2, Float:Z2, bool:found = false;
       			for (new i = 1; i < MAX_VEHICLES; i++)
                {
                    for (new x = 0; x < MAX_SUBS; x++)
                    {
                        if (GetVehicleModel(i) == 473 && i == gLifeboatInfo[x][vehicleID])
                        {
           					GetVehiclePos(i, X2, Y2, Z2);
		  	    			//if (IsPlayerInRangeOfPoint(playerid, 20.0, X2, Y2, Z2))
		  	    			if(GetDistance(X2, Y2, Z2, gSubmarineInfo[x][sX], gSubmarineInfo[x][sY], gSubmarineInfo[x][sZ]) < 20)
					        {
		      	    			found = true;
		      	    			DestroyVehicle(i);
		      	    			break;
							}
						}
					}
				}
				if (found)
				{
					SetTimerEx("LoadLifeboat", 2000+random(2500), false, "ii", playerid, gPlayerSubID[playerid]);
                    SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}SUBMARINE: Since you're near a lifeboat, it's being loaded on your submarine.");
				}
				else SendClientMessage(playerid, -1, "{FFFFFF}* {FC4949}SUBMARINE: You aren't near a lifeboat to load it back on your submarine!");
			}
		}
		else if (PRESSED(KEY_SECONDARY_ATTACK))
		{
            gPlayerState{playerid} = GetPlayerState(playerid);
			if (gPlayerInSub{playerid})
			{
				UnfreezePlayer(playerid);
				RemovePlayerFromSubmarine(playerid, gPlayerSubID[playerid]);
				SetPlayerHealth(playerid, 100.0);
				SetCameraBehindPlayer(playerid);
				SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}SUBMARINE: You've left the submarine.");
			}
		}
	}
	else
	{
		if(PRESSED(KEY_SECONDARY_ATTACK))
		{
			if (gPlayerState{playerid} == PLAYER_STATE_ONFOOT)
			{
				for (new i = 0; i < MAX_SUBS; i++)
				{
					if (gSubmarineInfo[i][IsActive] && !gSubmarineInfo[i][InUse])
					{
						if (IsPlayerInRangeOfPoint(playerid, 10.0, gSubmarineInfo[i][sX], gSubmarineInfo[i][sY], gSubmarineInfo[i][sZ]))
						{
						    //FreezePlayer(playerid);
							gPlayerCanShoot{ playerid } = false; gPlayerLoading{ playerid } = false;
							PutPlayerInSubmarine(playerid, i);
							SetPlayerHealth(playerid, 0x7F800000);

							SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}SUBMARINE: You've entered a submarine.");
							SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}SUBMARINE: Use movement keys to control it. Use {00FF00}Y{FFFFFF} to shoot a torpedo, and {00FF00}N{FFFFFF} to deploy a lifeboat.");
							break;
						}
					}
				}
			}
		}
	}
	return 1;
}

public OnPlayerUpdate(playerid)
{
	static Keys, ud, lr;
	GetPlayerKeys(playerid, Keys, ud, lr);
	
	if (gPlayerInSub{playerid})
	{
		static Float:x, Float:y, Float:z;
		
		if (ud < 0)
		{ // UP
			
			GetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], x, y, z);
			x -= (1.0 * floatsin(-gSubmarineInfo[gPlayerSubID[playerid]][sAngle], degrees));
			y -= (1.0 * floatcos(-gSubmarineInfo[gPlayerSubID[playerid]][sAngle], degrees));
			SetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], x, y, z);
			// Track submarine position
			GetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ]);
			return 1;
		}
		else if (ud > 0)
		{ // DOWN
			
			GetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], x, y, z);
			x += (0.5 * floatsin(-gSubmarineInfo[gPlayerSubID[playerid]][sAngle], degrees));
			y += (0.5 * floatcos(-gSubmarineInfo[gPlayerSubID[playerid]][sAngle], degrees));
			SetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], x, y, z);
			// Track submarine position
			GetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ]);
            return 1;
		}
		if (lr < 0)
		{ // LEFT
			GetObjectRot(gSubmarineInfo[gPlayerSubID[playerid]][Object], x, y, z);
			z += 0.5;
			SetObjectRot(gSubmarineInfo[gPlayerSubID[playerid]][Object], x, y, z);
			// Track submarine orientation
			gSubmarineInfo[gPlayerSubID[playerid]][sAngle] = z;
            return 1;
		}
		else if (lr > 0)
		{ // RIGHT
			GetObjectRot(gSubmarineInfo[gPlayerSubID[playerid]][Object], x, y, z);
			z -= 0.5;
			SetObjectRot(gSubmarineInfo[gPlayerSubID[playerid]][Object], x, y, z);
			// Track submarine orientation
			gSubmarineInfo[gPlayerSubID[playerid]][sAngle] = z;
			return 1;
		}
		if (Keys & KEY_JUMP)
		{
		    if (gSubmarineInfo[gPlayerSubID[playerid]][sZ] < 2.6)
		    {
				GetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ]);
				gSubmarineInfo[gPlayerSubID[playerid]][sZ] += 0.6;
				SetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ]);
				
				if (gSubmarineInfo[gPlayerSubID[playerid]][sZ] > 2.6)
				{
					GetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ]);
					SetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ] - 0.6);
					// Track submarine position
					GetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ]);
				}
			}
			else
			{
				if (gettime() - gPlayerSubWarnTick[playerid] > 3)
				{
					GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~r~MAX HEIGHT REACHED", 2500, 3);
					gPlayerSubWarnTick[playerid] = gettime();
				}
			}
			return 1;
		}
		
		if (Keys & KEY_SPRINT)
		{
		    if (gSubmarineInfo[gPlayerSubID[playerid]][sZ] > -20.0)
		    {
				
				GetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ]);
				gSubmarineInfo[gPlayerSubID[playerid]][sZ] -= 0.4;
				SetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ]);
				
				if (gSubmarineInfo[gPlayerSubID[playerid]][sZ] < -20.0)
				{
					
					GetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ]);
					SetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ] + 0.4);
					// Track submarine position
					GetObjectPos(gSubmarineInfo[gPlayerSubID[playerid]][Object], gSubmarineInfo[gPlayerSubID[playerid]][sX], gSubmarineInfo[gPlayerSubID[playerid]][sY], gSubmarineInfo[gPlayerSubID[playerid]][sZ]);
				}
			}
			else
			{
				if (gettime() - gPlayerSubWarnTick[playerid] > 2)
				{
					GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~r~MAX DEPTH REACHED", 1500, 3);
					gPlayerSubWarnTick[playerid] = gettime();
				}
			}
			return 1;
		}
		//
	}
	return 1;
}

public OnVehicleDeath(vehicleid, killerid)
{
    for (new x = 0; x < MAX_SUBS; x++)
    {
        if (vehicleid == gLifeboatInfo[x][vehicleID])
        {
            DestroyLifeboat(vehicleid);
		}
	}
	return 1;
}


public OnPlayerWeaponShot(playerid, weaponid, hittype, hitid, Float:fX, Float:fY, Float:fZ)
{
    if( hittype == BULLET_HIT_TYPE_OBJECT && hitid != INVALID_OBJECT_ID )
    {
  		if(hitid == gSubmarineInfo[hitid][Object])
  		{
    		if(gPlayerShot[playerid] != hitid) gPlayerDmg[playerid][hitid] = 0;
			switch(GetPlayerWeapon(playerid))
   			{
			   case 22, 23: gSubmarineInfo[hitid][Health]--;
			   case 24: gSubmarineInfo[hitid][Health] -= random(3);
			   case 25..27: gSubmarineInfo[hitid][Health] -= random(3);
			   case 28, 29, 32: gSubmarineInfo[hitid][Health] -= random(2);
			   case 30, 31: gSubmarineInfo[hitid][Health] -= random(4);
			   case 33, 34: gSubmarineInfo[hitid][Health] -= random(5);
			   case 38: gSubmarineInfo[hitid][Health] -= random(12);
			}
			gPlayerDmg[playerid][hitid] += random(12);
				
			new string[148], DialogString[240];
			if(gSubmarineInfo[hitid][Health] > 1)
			{
		 		gPlayerShot[playerid] = hitid;
		  		format(string, sizeof(string), "~r~SUBMARINE DAMAGED\n~y~%d/~r~500 ~y~health remaining", gSubmarineInfo[hitid][Health]);
				GameTextForPlayer(playerid, string, 1000, 3);
			}
			else
			{
		 		foreach(Player, x)
		 		{
		  			if(gPlayerShot[x] == hitid)
					{
					 	GameTextForPlayer(x, "~r~SUBMARINE DESTROYED", 2500, 3);
						format(DialogString, sizeof(DialogString), "%s\n{33AA33}%s dealt {FC4949}%d damage.", DialogString, GetName(x), gPlayerDmg[x][hitid]);
						format(string, sizeof(string), "* {33AA33}%s dealt {FC4949}%d damage {33AA33}to the {FC4949}Submarine.", GetName(x), gPlayerDmg[x][hitid]);
						SendClientMessageToAll(-1, string);
					}
				}
				ShowPlayerDialog(playerid, 0, DIALOG_STYLE_MSGBOX, "{33AA33}Players who assisted", DialogString, "Close", "");

				RemovePlayerFromSubmarine(gSubmarineInfo[hitid][UserID], hitid);
		     	DestroySubmarine(gSubmarineInfo[hitid][Object]); if(hitid != INVALID_OBJECT_ID) DestroySubmarine(hitid);
			}
		}
	}
	return 1;
}
/*----------------------------------------------------------------------------*/
PUB: FreezePlayer(playerid) return TogglePlayerControllable(playerid, false);
PUB: UnfreezePlayer(playerid) return TogglePlayerControllable(playerid, true);


PUB:DetonateTorpedo(submarineid, playerid, torpedoid)
{
	new Float:X, Float:Y, Float:Z;
	GetObjectPos(torpedoid, X, Y, Z);
	foreach(Player, i)
	{
		if (i == playerid || IsPlayerAdmin(i)) continue;
		if (IsPlayerInRangeOfPoint(i, 9.5, X, Y, Z))
		{
			if (IsPlayerInAnyVehicle(i)) SetVehicleHealth(i, 231), RemovePlayerFromVehicle(i);

			if(gPlayerInSub{ i }) RemovePlayerFromSubmarine(i, gPlayerSubID[i]); DestroySubmarine(gPlayerSubID[i]);
			SpawnPlayer(i);
			OnPlayerDeath(i, playerid, 51);
		}
	}
	CreateExplosion(X, Y + 1.0, Z, 2, 150.0);
	CreateExplosion(X, Y + 1.0, Z, 3, 150.0);
	CreateExplosion(X, Y + 1.0, Z, 4, 150.0);
	DestroyObject(torpedoid); if(gSubmarineInfo[submarineid][Object] != INVALID_OBJECT_ID) DestroyObject(gSubmarineInfo[submarineid][TorpedoObject]);
	return 1;
}
PUB:TorpedoLoadedT(playerid, submarineid)
{
	if (gSubmarineInfo[submarineid][Torpedos] > 0)
	{
		gSubmarineInfo[submarineid][TorpedoLoaded] = 1; gPlayerCanShoot{playerid} = true; gPlayerLoading{ playerid } = false;
		SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}SUBMARINE: Torpedo loaded, ready to be used!");
	}
	else SendClientMessage(playerid, -1, "{FFFFFF}* {FC4949}SUBMARINE: Could not find any torpedos..");
	return 1;
}
PUB:LifeboatLoaded(playerid, submarineid)
{
	CreateLifeboat(playerid, submarineid, gSubmarineInfo[submarineid][sX] + 4.0, gSubmarineInfo[submarineid][sY], gSubmarineInfo[submarineid][sZ], gSubmarineInfo[submarineid][sAngle]);
	SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}LIFEBOAT: Lifeboat deployed, exit the submarine and jump on the lifeboat!");
	return 1;
}
PUB:LoadLifeboat(playerid, submarineid)
{
    gSubmarineInfo[submarineid][LifeBoat] = 1;
	SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}SUBMARINE: The lifeboat has been successfully loaded on your submarine!");
	return 1;
}


stock CreateLifeboat(playerid, submarineid, Float:X, Float:Y, Float:Z, Float:Angle)
{
    gSubmarineInfo[gPlayerSubID[playerid]][LifeBoat] = 0;
	gLifeboatInfo[submarineid][vehicleID] = CreateVehicle(473, X, Y, Z, Angle, 8, 8, 120);
	gLifeboatInfo[submarineid][lbID] = submarineid;
	
}
stock DestroyLifeboat(submarineid)
{
	gLifeboatInfo[submarineid][lbID] = 0;
	DestroyVehicle(gLifeboatInfo[submarineid][vehicleID]);
}

stock CreateSubmarine(submarineid, Float:X, Float:Y, Float:Z, Float:Angle)
{
	gSubmarineInfo[submarineid][ID] = submarineid;
	gSubmarineInfo[submarineid][Object] = CreateObject(9958, X, Y, Z, 0.0, 0.0, Angle);
	gSubmarineInfo[submarineid][sX] = X, gSubmarineInfo[submarineid][sY] = Y, gSubmarineInfo[submarineid][sZ] = Z, gSubmarineInfo[submarineid][sAngle] = Angle;
	GetObjectPos(gSubmarineInfo[submarineid][Object], gSubmarineInfo[submarineid][sX], gSubmarineInfo[submarineid][sY], gSubmarineInfo[submarineid][sZ]);
	gSubmarineInfo[submarineid][Torpedos] = 4, gSubmarineInfo[submarineid][TorpedoLoaded] = 0;
	gSubmarineInfo[submarineid][LifeBoat] = 1, gSubmarineInfo[submarineid][LifeBoatID] = submarineid;
	gSubmarineInfo[submarineid][IsActive] = 1, gSubmarineInfo[submarineid][InUse] = 0;
	gSubmarineInfo[submarineid][Health] = 500;

	gSubmarines++;
}
stock DestroySubmarine(submarineid)
{
    gSubmarineInfo[submarineid][ID] = -1;
	DestroyObject(gSubmarineInfo[submarineid][Object]), gSubmarineInfo[submarineid][Object] = INVALID_OBJECT_ID;
	DestroyObject(gSubmarineInfo[submarineid][TorpedoObject]), gSubmarineInfo[submarineid][TorpedoObject] = INVALID_OBJECT_ID;
	gSubmarineInfo[submarineid][Torpedos] = 0, gSubmarineInfo[submarineid][TorpedoLoaded] = 0;
	gSubmarineInfo[submarineid][IsActive] = 0, gSubmarineInfo[submarineid][InUse] = 0;
	gSubmarineInfo[submarineid][Health] = 0;
	DestroyLifeboat(submarineid);

	gSubmarines--;
}
stock DestroySubmarines()
{
	for (new submarineid = 0; submarineid < MAX_SUBS; submarineid++)
	{
	    gSubmarineInfo[submarineid][ID] = -1;
		DestroyObject(gSubmarineInfo[submarineid][Object]), gSubmarineInfo[submarineid][Object] = INVALID_OBJECT_ID;
		DestroyObject(gSubmarineInfo[submarineid][TorpedoObject]), gSubmarineInfo[submarineid][TorpedoObject] = INVALID_OBJECT_ID;
		gSubmarineInfo[submarineid][sX] = 0.0, gSubmarineInfo[submarineid][sY] = 0.0, gSubmarineInfo[submarineid][sZ] = 0.0, gSubmarineInfo[submarineid][sAngle] = 0.0;
		gSubmarineInfo[submarineid][Torpedos] = 0, gSubmarineInfo[submarineid][TorpedoLoaded] = 0;
		gSubmarineInfo[submarineid][IsActive] = 0, gSubmarineInfo[submarineid][InUse] = 0;
		gSubmarineInfo[submarineid][Health] = 0;
		DestroyLifeboat(submarineid);
	}

	gSubmarines = 0;
}

stock GetAvailableID()
{
	for (new i = 0; i < MAX_SUBS; i++)
 	{
  		if (!gSubmarineInfo[i][IsActive]) return i;
    }
    return MAX_SUBS;
}
stock GetName(playerid)
{
	new pnameid[24];
	GetPlayerName(playerid,pnameid,sizeof(pnameid));
	return pnameid;
}
stock GetPlayerSpeed(playerid)
{
    new Float:ST[4];
    if(IsPlayerInAnyVehicle(playerid))
    GetVehicleVelocity(GetPlayerVehicleID(playerid),ST[0],ST[1],ST[2]);
    else GetPlayerVelocity(playerid,ST[0],ST[1],ST[2]);
    ST[3] = floatsqroot(floatpower(floatabs(ST[0]), 2.0) + floatpower(floatabs(ST[1]), 2.0) + floatpower(floatabs(ST[2]), 2.0)) * 169.28625;
    return floatround(ST[3]);
}


stock ResetData(playerid)
{
   	gPlayerState[playerid] = GetPlayerState(playerid);
	gPlayerSubID[playerid] = -1;

	gPlayerCamObj[playerid] = INVALID_OBJECT_ID;

	gPlayerInSub{playerid} = false;
	gPlayerCanShoot{ playerid } = false; gPlayerLoading{ playerid } = false;
	gPlayerSubWarnTick[playerid] = 0;
	gPlayerShot[playerid] = -1;
	for (new i = 0; i < MAX_SUBS; i++) gPlayerDmg[playerid][i] = 0;
}

PUB:UpdateStats(playerid, submarineid)
{
 	if(gPlayerInSub{ playerid })
	{
		if(gPlayerSubID[playerid] == gSubmarineInfo[submarineid][ID])
  		{
    		GetObjectPos(gSubmarineInfo[submarineid][Object], gSubmarineInfo[submarineid][sX], gSubmarineInfo[submarineid][sY], gSubmarineInfo[submarineid][sZ]);
		    SetPlayerPos(playerid, gSubmarineInfo[submarineid][sX], gSubmarineInfo[submarineid][sY], gSubmarineInfo[submarineid][sZ]);
		    
			new string[148], string2[4], Float:rotation;
			GetObjectRot(gSubmarineInfo[submarineid][Object], rotation, rotation, rotation);
			new direction = floatround(rotation,floatround_round);
			while(direction > 360) direction -= 360;
			while(direction < 0) direction += 360;
			switch(direction)
		    {
          		case 0..22: string2 = "S";
		        case 23..67: string2 = "SE";
		        case 68..112: string2 = "E";
		        case 113..157: string2 = "NE";
		        case 158..202: string2 = "N";
		        case 203..247: string2 = "NW";
		        case 248..292: string2 = "W";
		        case 293..337: string2 = "SW";
		        case 338..360: string2 = "S";
		        /*case 0..22: string2 = "S"; //N
		        case 23..67: string2 = "NW";
		        case 68..112: string2 = "W";
		        case 113..157: string2 = "SW";
		        case 158..202: string2 = "N"; //S
		        case 203..247: string2 = "SE";
		        case 248..292: string2 = "E";
		        case 293..337: string2 = "NE";
		        case 338..360: string2 = "S"; //N*/
		    }
			format(string, sizeof(string), "~w~TORPEDOS: ~y~%d~n~~w~LIFEBOAT: ~y~%d~n~~w~ARMOUR: ~y~%d~n~~w~ALTITUDE: ~y~%0.2f~n~~w~SPEED: ~y~%d knots~n~~w~DIRECTION: ~y~%s", gSubmarineInfo[submarineid][Torpedos], gSubmarineInfo[submarineid][LifeBoat], gSubmarineInfo[submarineid][Health], gSubmarineInfo[submarineid][sZ], GetPlayerSpeed(playerid), string2);
			TextDrawSetString(SubInfo[playerid], string);
			TextDrawShowForPlayer(playerid, SubInfo[playerid]);
			TextDrawShowForPlayer(playerid, SubBox[playerid]);
			SetPlayerFacingAngle(playerid, rotation);
			
			SetPlayerArmedWeapon(playerid, 0);
		}
	}
	else KillTimer(Timer[playerid]);
	return 1;
}
/*----------------------------------------------------------------------------*/

CMD:createsubmarine(playerid, params[])
{
	if (!IsPlayerAdmin(playerid)) return 0;

	new Float:X, Float:Y, Float:Z, Float:Angle;
	GetPlayerPos(playerid, X, Y, Z);
	if (Z > 1.0) return SendClientMessage(playerid, -1, "{FFFFFF}* {FC4949}SUBMARINE: Your position is too high to create an submarine ( not in water ? )");
	else if (Z < -1.0) return SendClientMessage(playerid, -1, "{FFFFFF}* {FC4949}SUBMARINE: Your position is too low to create an submarine ( below water ? )");

	new subID = GetAvailableID();
	if (subID < 20)
	{
		GetPlayerPos(playerid, X, Y, Z), GetPlayerFacingAngle(playerid, Angle);
		
		CreateSubmarine(subID, X, Y, Z+3.0, Angle+180.0);
		
		SetPlayerPos(playerid, X, Y, Z+6.0);
		//gPlayerCamObj[playerid] = CreateObject(19300, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
		//AttachObjectToObject(gPlayerCamObj[playerid], gSubmarineInfo[subID][Object], 0.0, -5.0, 1.6, 0.0, 0.0, 0.0);
	}
	else SendClientMessage(playerid, -1, "{FFFFFF}* {FC4949}SUBMARINE: The max. amount of submarines has been reached.");
	return 1;
}
CMD:destroysubmarine(playerid, params[])
{
    if (!IsPlayerAdmin(playerid)) return 0;

	if (gSubmarines)
	{
		new subID;
		if (sscanf(params, "d", subID)) return SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}USAGE: /destroysubmarine ID");
		if (subID > 20 && subID < 0) return SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}USAGE: /destroysubmarine ID[0-20]");
		
		if (gSubmarineInfo[subID][InUse]) return SendClientMessage(playerid, -1, "{FFFFFF}* {FC4949}SUBMARINE: This submarine is in use.");
		if (gSubmarineInfo[subID][IsActive]) DestroySubmarine(subID);
		else SendClientMessage(playerid, -1, "{FFFFFF}* {FC4949}SUBMARINE: Submarine not active!");
	}
	else SendClientMessage(playerid, -1, "{FFFFFF}* {FC4949}SUBMARINE: The aren't any submarines spawned!");
	return 1;
}
CMD:destroysubmarines(playerid, params[])
{
    if (!IsPlayerAdmin(playerid)) return 0;

	if (gSubmarines) DestroySubmarines();
	else SendClientMessage(playerid, -1, "{FFFFFF}* {FC4949}SUBMARINE: There aren't any submarines spawned!");
	return 1;
}

CMD:submarine(playerid, params[])
{
    gPlayerState{playerid} = GetPlayerState(playerid);
	if (gPlayerInSub{playerid})
	{
		UnfreezePlayer(playerid);
		RemovePlayerFromSubmarine(playerid, gPlayerSubID[playerid]);
		SetPlayerHealth(playerid, 100.0);
		SetCameraBehindPlayer(playerid);
		SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}SUBMARINE: You've left the submarine.");
	}
	else
	{
		if (gPlayerState{playerid} == PLAYER_STATE_ONFOOT)
		{
			for (new i = 0; i < MAX_SUBS; i++)
			{
				if (gSubmarineInfo[i][IsActive] && !gSubmarineInfo[i][InUse])
				{
					if (IsPlayerInRangeOfPoint(playerid, 10.0, gSubmarineInfo[i][sX], gSubmarineInfo[i][sY], gSubmarineInfo[i][sZ]))
					{
						//FreezePlayer(playerid);
						gPlayerCanShoot{ playerid } = false; gPlayerLoading{ playerid } = false;
						PutPlayerInSubmarine(playerid, i);
						SetPlayerHealth(playerid, 0x7F800000);
						
						SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}SUBMARINE: You've entered a submarine.");
						SendClientMessage(playerid, -1, "{FFFFFF}* {00C0FF}SUBMARINE: Use movement keys to control it. Use {00FF00}Y{FFFFFF} to shoot a torpedo, and {00FF00}N{FFFFFF} to deploy a lifeboat.");
						break;
					}
					else SendClientMessage(playerid, -1, "{FFFFFF}* {FC4949}SUBMARINE: You're not near any submarines!");
				}
			}
		}
		//else RemovePlayerFromVehicle(playerid);
	}
	return 1;
}
